/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.wizard;

import com.quantumdata.sct.gui.common.MessageOptionPane;
import com.quantumdata.sct.gui.common.SCTButton;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.common.SCTLabel;
import com.quantumdata.sct.gui.common.SCTPanel;
import com.quantumdata.sct.gui.wizard.IBOHandler;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class IBODialog
extends JDialog
implements ActionListener {
    private SCTButton newButton;
    private SCTButton updateButton;
    private SCTButton deleteButton;
    private SCTButton okButton;
    private boolean okBtnPressed = false;
    private IBOHandler currentHandler;

    public IBODialog(JDialog jDialog) {
        super((Dialog)jDialog, true);
        this.init();
    }

    public IBODialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.init();
    }

    private void init() {
        Container container = this.getContentPane();
        this.setTitle("IBO Operations");
        container.add(this.newIBOPanel());
        this.pack();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                IBODialog.this.pack();
            }
        });
        SCTConstants.screenCenterPlacement(this);
    }

    private SCTPanel newIBOPanel() {
        SCTPanel sCTPanel = new SCTPanel();
        BoxLayout boxLayout = new BoxLayout(sCTPanel, 1);
        sCTPanel.setLayout(boxLayout);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        SCTPanel sCTPanel2 = new SCTPanel(gridBagLayout);
        SCTLabel sCTLabel = new SCTLabel(" New ");
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(sCTLabel, gridBagConstraints);
        sCTPanel2.add(sCTLabel);
        this.newButton = new SCTButton("New..");
        this.newButton.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.newButton, gridBagConstraints);
        sCTPanel2.add(this.newButton);
        SCTLabel sCTLabel2 = new SCTLabel(" Update ");
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(sCTLabel2, gridBagConstraints);
        sCTPanel2.add(sCTLabel2);
        this.updateButton = new SCTButton("Update..");
        this.updateButton.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.updateButton, gridBagConstraints);
        sCTPanel2.add(this.updateButton);
        SCTLabel sCTLabel3 = new SCTLabel(" Delete ");
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(sCTLabel3, gridBagConstraints);
        sCTPanel2.add(sCTLabel3);
        this.deleteButton = new SCTButton("Delete..");
        this.deleteButton.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.deleteButton, gridBagConstraints);
        sCTPanel2.add(this.deleteButton);
        this.okButton = new SCTButton("Done");
        this.okButton.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        sCTPanel2.add(this.okButton);
        sCTPanel.add(sCTPanel2);
        return sCTPanel;
    }

    public IBOHandler getCurrentHandler() {
        return this.currentHandler;
    }

    public void setCurrentHandler(IBOHandler iBOHandler) {
        if (iBOHandler != null) {
            this.currentHandler = iBOHandler;
        }
        this.preSelect();
    }

    public void preSelect() {
        if (this.currentHandler != null) {
            this.newButton.setEnabled(this.currentHandler.isEnabled((short)1));
            this.updateButton.setEnabled(this.currentHandler.isEnabled((short)2));
            this.deleteButton.setEnabled(this.currentHandler.isEnabled((short)3));
        } else {
            this.newButton.setEnabled(false);
            this.updateButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }

    public boolean isokBtnPressed() {
        return this.okBtnPressed;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MessageOptionPane messageOptionPane = new MessageOptionPane();
        if (actionEvent.getSource() == this.okButton) {
            this.dispose();
            return;
        }
        if (this.currentHandler == null) {
            return;
        }
        if (actionEvent.getSource() == this.newButton) {
            String string = null;
            try {
                string = this.currentHandler.handleAction((short)1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                MessageOptionPane.ShowErrorMessage(this.getParent(), exception.getMessage(), "Error");
                return;
            }
            if (string != null) {
                MessageOptionPane.ShowMessage(this.getParent(), string, string);
            }
            this.dispose();
        } else if (actionEvent.getSource() == this.updateButton) {
            String string = null;
            try {
                string = this.currentHandler.handleAction((short)2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                MessageOptionPane.ShowErrorMessage(this.getParent(), exception.getMessage(), "Error");
                return;
            }
            if (string != null) {
                MessageOptionPane.ShowMessage(this.getParent(), string, string);
            }
            this.dispose();
        } else if (actionEvent.getSource() == this.deleteButton) {
            String string = null;
            try {
                string = this.currentHandler.handleAction((short)3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                MessageOptionPane.ShowErrorMessage(this.getParent(), exception.getMessage(), "Error");
                return;
            }
            if (string != null) {
                MessageOptionPane.ShowMessage(this.getParent(), string, string);
            }
            this.dispose();
        }
    }

    public void newCurrent() {
        MessageOptionPane messageOptionPane = new MessageOptionPane();
        String string = null;
        try {
            string = this.currentHandler.handleAction((short)1);
        }
        catch (NullPointerException nullPointerException) {
            MessageOptionPane.ShowErrorMessage(this.getParent(), "You cannot add a new file in this window.", "Error");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            MessageOptionPane.ShowErrorMessage(this.getParent(), exception.getMessage(), "Error");
            return;
        }
        if (string != null) {
            MessageOptionPane.ShowMessage(this.getParent(), string, string);
        }
    }

    public void deleteCurrent() {
        MessageOptionPane messageOptionPane = new MessageOptionPane();
        String string = null;
        try {
            string = this.currentHandler.handleAction((short)3);
        }
        catch (NullPointerException nullPointerException) {
            MessageOptionPane.ShowErrorMessage(this.getParent(), "You cannot delete a file in this window.", "Error");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            MessageOptionPane.ShowErrorMessage(this.getParent(), exception.getMessage(), "Error");
            return;
        }
        if (string != null) {
            MessageOptionPane.ShowMessage(this.getParent(), string, string);
        }
    }

    public void updateCurrent() {
        MessageOptionPane messageOptionPane = new MessageOptionPane();
        String string = null;
        try {
            string = this.currentHandler.handleAction((short)2);
        }
        catch (NullPointerException nullPointerException) {
            MessageOptionPane.ShowErrorMessage(this.getParent(), "You cannot update a file in this window.", "Error");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            MessageOptionPane.ShowErrorMessage(this.getParent(), exception.getMessage(), "Error");
            return;
        }
        if (string != null) {
            MessageOptionPane.ShowMessage(this.getParent(), string, string);
        }
    }
}

